<?php
$offername = $_GET['offer'];
$lang = $_POST['language'] ?? $_GET['language'] ?? 'es';
?>
<!DOCTYPE html>
<html lang="<?= htmlspecialchars($lang) ?>">
<head>
  <meta charset="UTF-8">
  <title></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@17.0.8/build/css/intlTelInput.min.css">
  <style>
    formt#body { background: #f2f2f2; font-family: Arial; padding: 40px; }
    .form-container {
      background: #fff; max-width: 500px; margin: auto; padding: 30px;
      border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    label { font-weight: bold; margin-top: 10px; display: block; }
    input[type="text"], input[type="email"], input[type="tel"] {
      width: 100%; padding: 10px; margin-top: 5px; border: 1px solid #ccc; border-radius: 5px;
    }
    .success-message { color: green; font-size: 16px; margin-top: 15px; text-align: center; display:none;}
    .error-message { color: red; font-size: 14px; margin-top: 5px; text-align:center; display:none;}
    button {
      margin-top: 20px; width: 100%; padding: 12px; background-color: #dc2626;
      border: none; color: white; border-radius: 5px; font-size: 16px;
    }
    button:hover { background-color: #0056b3; }

    /* Popup modal */
    .modal-overlay {
      position: fixed; inset: 0; background: rgba(0,0,0,.5);
      display: none; align-items: center; justify-content: center; z-index: 9999;
    }
    .modal {
      background: #fff; max-width: 520px; width: 92%; border-radius: 12px;
      box-shadow: 0 10px 30px rgba(0,0,0,.2); padding: 26px 22px; text-align: center;
    }
    .modal h3 { margin: 0 0 8px; font-size: 20px; }
    .modal p { margin: 0; font-size: 15px; color: #444; }
    .modal .spinner {
      margin: 16px auto 0; width: 40px; height: 40px; border-radius: 50%;
      border: 4px solid #e5e7eb; border-top-color: #dc2626; animation: spin 1s linear infinite;
    }
    @keyframes spin { to { transform: rotate(360deg); } }
    #pixelContainer { width:0; height:0; overflow:hidden; }
  </style>
</head>
<body id="formt">
<form class="form-container" id="crmForm" method="post" autocomplete="off">
  <h2></h2>
  <div class="success-message" id="successMsg">¡Su información ha sido enviada!</div>
  <div class="error-message" id="errorMsg">Algo salió mal. Inténtalo de nuevo.</div>

  <label for="fname">Nombre de pila *</label>
  <input type="text" id="fname" name="fname" required>

  <label for="lname">Apellido *</label>
  <input type="text" id="lname" name="lname" required>

  <label for="email">E-mail *</label>
  <input type="email" id="email" name="email" required>

  <label for="fullphone">Número de teléfono *</label>
  <input type="tel" id="fullphone" name="fullphone" required>

  <input type="hidden" name="ip" id="ip">
  <input type="hidden" name="country" id="country">
  <input type="hidden" name="language" value="es">
  <input type="hidden" name="source" value="">
  <input type="hidden" name="funnel" value="<?php echo $offername; ?>-p-es">
  <input type="hidden" name="link_id" value="">
  <input type="hidden" name="click_id" value="">
  <input type="hidden" name="utm_campaign" value="">

  <button type="submit">Registro</button>
</form>

<!-- Popup modal -->
<div id="thankyouModal" class="modal-overlay" role="dialog" aria-modal="true">
  <div class="modal">
    <h3>Gracias por registrarse.</h3>
    <p>En breve serás redirigido a nuestra plataforma.</p>
    <div class="spinner"></div>
    <div id="pixelContainer"></div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@17.0.8/build/js/intlTelInput.min.js"></script>
<script>
let enableRedirect = true;

// Fill hidden fields from URL parameters
function fillHiddenFromURL(param, fieldId) {
  const urlParams = new URLSearchParams(window.location.search);
  const val = urlParams.get(param);
  if (val && document.getElementsByName(fieldId)[0]) {
    document.getElementsByName(fieldId)[0].value = val;
  }
}
['source', 'link_id', 'click_id', 'utm_campaign', 'funnel'].forEach(param => fillHiddenFromURL(param, param));

window.addEventListener("DOMContentLoaded", function () {
  const iti = window.intlTelInput(document.querySelector("#fullphone"), {
    initialCountry: "auto",
    separateDialCode: true,
    nationalMode: false,
    utilsScript: "https://cdn.jsdelivr.net/npm/intl-tel-input@17.0.8/build/js/utils.js",
    geoIpLookup: function(callback) {
      fetch("https://api.ipstack.com/check?access_key=061a864446c4fc350c3a20c2b0405122")
        .then(response => response.json())
        .then(data => {
          document.getElementById("ip").value = data.ip;
          document.getElementById("country").value = data.country_code || "US";
          callback(data.country_code || "US");
        })
        .catch(() => {
          document.getElementById("country").value = "US";
          callback("US");
        });
    }
  });

  const crm_api_url = "https://tracking.spartas360.com/api/v3/integration?api_token=kOkHnApjNGnjCcYKe2pIqdoeVaBxfNrkeNekm23Q17P8PXtxU8QDLGZRUkV7";

  function showThankYouAndRedirect(url) {
    const modal = document.getElementById('thankyouModal');
    const pixelContainer = document.getElementById('pixelContainer');
    pixelContainer.innerHTML = '<iframe src="pixel.html' + window.location.search + '" width="0" height="0" style="border:0; visibility:hidden;"></iframe>';
    modal.style.display = 'flex';
    if (enableRedirect && url && typeof url === 'string' && url.startsWith('http')) {
      setTimeout(() => { window.location.href = url; }, 5000);
    }
  }

  document.getElementById("crmForm").addEventListener("submit", function(e) {
    e.preventDefault();
    document.getElementById('successMsg').style.display = 'none';
    document.getElementById('errorMsg').style.display = 'none';
    document.getElementById("fullphone").value = iti.getNumber();

    const formData = new FormData(this);
    const data = {};
    formData.forEach((val, key) => data[key] = val);

    fetch(crm_api_url, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(data)
    })
    .then(res => res.json())
    .then(response => {
      if (enableRedirect && response.autologin && response.autologin.startsWith("http")) {
        showThankYouAndRedirect(response.autologin);
      } else if (response.message || response.error) {
        document.getElementById('errorMsg').innerText = response.message || response.error;
        document.getElementById('errorMsg').style.display = 'block';
      } else {
        showThankYouAndRedirect(null);
      }
    })
    .catch(() => {
      document.getElementById('errorMsg').innerText = "Something went wrong. Please try again.";
      document.getElementById('errorMsg').style.display = 'block';
    });
  });
});
</script>
</body>
</html>